/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/

/**
 * \file    DM814x_uart.h
 *
 * \brief   Defines the module register defines for UART
 *
 * This header file contains the Macros definitions and the
 * register overlay structure for DM814x UART controller.
 *
 * \author  0043
 *
 * \version 01a,09aug,2010 Created.
 */

#ifndef _DM814x_uart_H_
#define _DM814x_uart_H_

#ifdef __cplusplus
 extern "C" {
#endif

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_SoC.h"

/**
@addtogroup DM814x UART
@{
*/

/*
 *====================
 * Defines
 *====================
 */
#define DM814x_UART0_BASE             (0x48020000u)
/**< Base address of UART 0                                                */
#define DM814x_UART1_BASE             (0x48022000u)
/**< Base address of UART 1                                                */
#define DM814x_UART2_BASE             (0x48024000u)
/**< Base address of UART 2                                                */
#define DM814x_UART3_BASE             (0x481A6000u)
/**< Base address of UART 3                                                */
#define DM814x_UART4_BASE             (0x481A8000u)
/**< Base address of UART 4                                                */
#define DM814x_UART5_BASE             (0x481AA000u)
/**< Base address of UART 5                                                */

#define RHR_OFFSET                     0x0  
/**< Receive Hold register - Read only register                            */
#define THR_OFFSET                     0x0  
/**< Transmit Hold register - Write only register						   */
#define IER_OFFSET                     0x4  
/**< Interrupt Enable Register - To Access: EFR[4]=1					   */
#define IIR_OFFSET                     0x8  
/**< Interrupt Identification register - Read only register				   */
#define FCR_OFFSET                     0x8  
/**< FIFO Control Registger - Write only register - To access: EFR[4] = 1  */
#define LCR_OFFSET                     0xc
/**< Line Control Registger                     						   */
#define MCR_OFFSET                     0x10 
/**< Mode Control - To Access: EFR[4] = 1	     						   */
#define LSR_OFFSET                     0x14 
/**< Line Status register - Read only register						       */
#define MSR_OFFSET                     0x18 
/**< Modem Status register - Read only register						       */
#define TCR_OFFSET                     0x18 
/**< Transmission Control register - To Access: EFR[4] = 1 & MCR[6] = 1    */
#define TLR_OFFSET                     0x1c 
/**< Trigger Level register - To Access: EFR[4]=1 & MCR[6]=1               */
#define SPR_OFFSET                     0x1c
/**< Scratch Pad register                   						       */
#define MDR1_OFFSET                    0x20
/**< Mode Definition register 1											   */
#define MDR2_OFFSET                    0x24
/**< Mode Definition register 2											   */
#define SFLSR_OFFSET                   0x28 
/**< Status FIFO Line Status Register - Read Only register 				   */
#define TXFLL_OFFSET                   0x28 
/**< Transmit Frame Length Low Register - Wite Only register 			   */
#define RESUME_OFFSET                  0x2c 
/**< Status FIFO Line Status Register - Read Only register 				   */
#define TXFLH_OFFSET                   0x2c 
/**< Transmit Frame Length High Register - Wite Only register 			   */
#define SFREGL_OFFSET                  0x30 
/**< Status FIFO Low Register - Wite Only register 			               */
#define RXFLL_OFFSET                   0x30 
/**< Receive Frame Length Low Register - Wite Only register 			   */
#define SFREGH_OFFSET                  0x34 
/**< Status FIFO High Register - Wite Only register 			           */
#define RXFLH_OFFSET                   0x34 
/**< Receive Frame Length high Register - Wite Only register 			   */
#define BLR_OFFSET                     0x38
/**< BOF Control Register   								 			   */
#define ACREG_OFFSET                   0x3c
/**< Auxiliary Control Register   								 		   */
#define SCR_OFFSET                     0x40
/**< Supplementary  Control Register   								 	   */
#define SSR_OFFSET                     0x44 
/**< Supplementary  Status Register   								 	   */
#define EBLR_OFFSET                    0x48
/**< BOF Length Register   								 	               */
#define MVR_OFFSET                     0x50 // Read only
/**< Module version Register   								 	           */
#define SYSC_OFFSET                    0x54
/**< System Configuration Register   								 	   */
#define SYSS_OFFSET                    0x58
/**< System Status Register   								 	           */
#define WER_OFFSET                     0x5C
/**< Wake-up Enable Register   								 	           */
#define CFPS_OFFSET                    0x60
/**< Carrier Frequency Pre-scaller Register   							   */
#define RXFIFO_LVL_OFFSET              0x64
/**< Receive FIFO level Register   							               */
#define TXFIFO_LVL_OFFSET              0x68
/**< Transmit FIFO Level Register   							           */
#define IER2_OFFSET              	   0x6C
/**< Interrupt Enable 2 Register   							               */
#define ISR2_OFFSET              	   0x70
/**< Interrupt Status 2 Register   							               */

/* ------------------------------------------------------------------------ *
 *  Control Registers for: UART Registers minus Base Address (  )           *
 *  These Registers are available with "LCR[bit 7] = 1"                     *
 * ------------------------------------------------------------------------ */
#define USE_LCR_80              ( 0x100 )
#define DLL                     ( USE_LCR_80 + 0x0 )
#define DLH                     ( USE_LCR_80 + 0x4 )
#define UASR                    ( USE_LCR_80 + 0x38 )

/* ------------------------------------------------------------------------ *
 *  Control Registers for: UART Registers minus Base Address (  )           *
 * These Registers are available with "LCR = 0xBF"                          *
 * ------------------------------------------------------------------------ */
#define USE_LCR_BF              ( 0x200 )
#define EFR                     ( USE_LCR_BF + 0x8 )
#define XON1                    ( USE_LCR_BF + 0x10 )
#define XON2                    ( USE_LCR_BF + 0x14 )
#define XOFF1                   ( USE_LCR_BF + 0x18 )
#define XOFF2                   ( USE_LCR_BF + 0x1c )


/* @} */   /* End of UART */

#ifdef __cplusplus
} /* End of extern C */
#endif /* #ifdef __cplusplus */

#endif  /* End of _DM814x_uart_H_ */
